/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.extendedexchange.recipes.ModRecipeSerializers;
import dev.ftb.extendedexchange.recipes.ModRecipeTypes;
import dev.ftb.extendedexchange.recipes.RecipeHelper;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableRecipe
implements Recipe<Container> {
    private static final long MIN_RECIPE_EMC_COST = 64L;
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final long emcOverride;
    private final int craftingTime;

    public AlchemyTableRecipe(ResourceLocation id, Ingredient input, ItemStack output, long emcOverride, int craftingTime) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.emcOverride = emcOverride;
        this.craftingTime = craftingTime;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.ALCHEMY_TABLE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ALCHEMY_TABLE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public long getTotalCost(ItemStack inputStack) {
        return this.emcOverride > 0L ? this.emcOverride : Math.max(64L, (ProjectEAPI.getEMCProxy().getValue(inputStack) + ProjectEAPI.getEMCProxy().getValue(this.output)) * 3L);
    }

    public int getCraftingTime() {
        return this.craftingTime > 0 ? this.craftingTime : 200;
    }

    public void toJson(JsonObject json) {
        json.add("input", this.input.m_43942_());
        json.add("output", RecipeHelper.serializeOneItemStack(this.output));
        json.addProperty("emc_override", (Number)this.emcOverride);
        json.addProperty("crafting_time", (Number)this.craftingTime);
    }

    public static class Serializer<T extends AlchemyTableRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("output"));
            long emcOverride = json.has("emc_override") ? json.get("emc_override").getAsLong() : 0L;
            int progressOverride = json.has("crafting_time") ? json.get("crafting_time").getAsInt() : 200;
            return this.factory.create(recipeId, input, output, emcOverride, progressOverride);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            long emcOverride = buffer.readLong();
            int progressOverride = buffer.readInt();
            return this.factory.create(recipeId, input, output, emcOverride, progressOverride);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlchemyTableRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.writeLong(recipe.emcOverride);
            buffer.writeInt(recipe.craftingTime);
        }

        public static interface IFactory<T extends AlchemyTableRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, ItemStack var3, long var4, int var6);
        }
    }
}

